// 
// Hott pour télémesure Graupner Hott
// 
// Gestion messagerie Hott
//
// Auteur : www.thyzoon.fr 
// 2016-2018
//

#define LEDSECU_OFF           PORTD &= ~(1<<4);
#define LEDSECU_ON            PORTD |= (1<<4);

#include "Message.h"
#include "Mesure.h"
#include <EEPROM.h>

#define VERSION         "2.08"

// -------------------------------------
// Valeurs par défaut stockées en EEPROM
//
#define REG_MOT_MAX     1000  // Regime moteur maxi. pour limitation du compte-tours (/10)
#define REG_MOT_MIN     50    // Regime moteur mini. pour limitation du compte-tours (/10)
#define TENSION_MIN     720   // 720 = 7.20V pour 2 elements Lipo
#define CHRONO_MOTEUR   480   //  480s = 8 minutes
#define ALARME_REPET    30    // 30s
#define TEMPERATURE_MAX 100   // 100°C
#define ALARME_OFF      0     // OFF   
#define FRANCAIS        0     // 0 = Francais
#define ANGLAIS         1     // 1 = Anglais

// buffer message
static uint8_t _hott_serial_buffer[173];   //création d'une variable tampon pour stocker les struct

// pointer des structures vers le tampon "_hott_serial_buffer"
struct HOTT_GAM_MSG         *hott_gam_msg = (struct HOTT_GAM_MSG *)&_hott_serial_buffer[0];
struct HOTT_TEXTMODE_MSG	*hott_txt_msg =	(struct HOTT_TEXTMODE_MSG *)&_hott_serial_buffer[0];

word regime_moteur_mini; // Régime moteur maxi du compte-tours  
word regime_moteur_maxi; // Régime moteur maxi du compte-tours         
word tension1_mini;      // Tension mini accu 1
word tension2_mini;      // Tension mini accu 1        
word chrono_moteur;      // temps alarme moteur
word alarme_repet;       // temps de repetition alarme
word temperature_maxi;   // temperature d'alarme moteur
word alarme_on_temperature; // alarme ON temperature
word alarme_on_chrono;    // alarme ON chrono temps moteur
word alarme_on_v1;        // alarme ON tension V1
word alarme_on_v2;        // alarme ON tension V2 
word langue;             // langue des menus de parametrage

extern word trmn_helice_hott;   // tours par minutes hélice
extern word Temps_moteur;  // en s 
extern int Temperature_capteur_1; // temperature capteur 1 moteur
extern int Temperature_capteur_2; // temperature capteur 2 moteur
extern byte bip_alarme;         // son de l'alarme

// For communication
static uint8_t octet1 = 0;  // reception
static uint8_t octet2 = 0;  // reception

// Sauvegardedes parametres en EEPROM 
/*
 !WARNING!
 Writing takes 3.3ms.
 Maximum life of the EEPROM is 100000 writings/readings.
 */
// Adresses des parametres en EEPROM, tous les parametres sont stockes sur 16 bits.  
#define adr_eprom_init 0                 // For the test for 1st time init of the Arduino (First power on)
#define adr_eprom_v1_mini 2              // Tension mini de l'accu 1
#define adr_eprom_v2_mini 4              // Tension mini de l'accu 2
#define adr_eprom_regime_mini 6          // Régime moteur maxi du compte-tours 
#define adr_eprom_regime_maxi 8          // Régime moteur maxi du compte-tours 
#define adr_eprom_chrono_moteur 10       // Temps moteur tournant en secondes pour alarme
#define adr_eprom_alarme_repet 12        // Temps de repetition de l'alarme en secondes
#define adr_eprom_temperature_max 14     // Temperature maxi moteur
#define adr_eprom_alarme_chrono 16       // Activation alarme temps moteur
#define adr_eprom_alarme_temperature 18  // Activation alarme temperature moteur
#define adr_eprom_alarme_v1 20           // Activation alarme tension V1
#define adr_eprom_alarme_v2 22           // Activation alarme tension V2
#define adr_eprom_langue 24              // Langue menu parametrage

// Gestion des mesure de tension
extern Mesure analogique;

GMessage::GMessage(){

}
void GMessage::init(){
  
// Initialisation COM 19200 bauds pour recepteur HOTT GRxx
  Serial.begin (SERIAL_COM_SPEED); 
  
  // ******************************************************
  // Test for 1st time init of the Arduino (First power on)
  int test = read_eprom(adr_eprom_init);
  if (test != 120)
  {
    write_eprom(adr_eprom_init,120);
    write_eprom(adr_eprom_v1_mini,TENSION_MIN); 
    write_eprom(adr_eprom_v2_mini,TENSION_MIN); 
    write_eprom(adr_eprom_regime_mini,REG_MOT_MIN); 
    write_eprom(adr_eprom_regime_maxi,REG_MOT_MAX); 
    write_eprom(adr_eprom_chrono_moteur,CHRONO_MOTEUR); 
    write_eprom(adr_eprom_alarme_repet,ALARME_REPET); 
    write_eprom(adr_eprom_temperature_max,TEMPERATURE_MAX);    
    write_eprom(adr_eprom_alarme_chrono,ALARME_OFF); 
    write_eprom(adr_eprom_alarme_temperature,ALARME_OFF); 
    write_eprom(adr_eprom_alarme_v1,ALARME_OFF); 
    write_eprom(adr_eprom_alarme_v2,ALARME_OFF); 
    write_eprom(adr_eprom_langue,FRANCAIS);    	
  }
  // Read saved values from EEPROM
  tension1_mini = read_eprom(adr_eprom_v1_mini);  // Lecture de la tension mini Accu 1
  tension2_mini = read_eprom(adr_eprom_v2_mini);  // Lecture de la tension mini Accu 2
  regime_moteur_mini = read_eprom(adr_eprom_regime_mini);  // Régime moteur mini du compte-tours  
  regime_moteur_maxi = read_eprom(adr_eprom_regime_maxi);  // Régime moteur maxi du compte-tours  
  chrono_moteur = read_eprom(adr_eprom_chrono_moteur);    // Temps alarme moteur  
  alarme_repet  = read_eprom(adr_eprom_alarme_repet);     // temps de repetition
  temperature_maxi = read_eprom(adr_eprom_temperature_max);  // Temperature max moteur
  alarme_on_chrono = read_eprom(adr_eprom_alarme_chrono);      // Activation alarme chrono
  alarme_on_temperature = read_eprom(adr_eprom_alarme_temperature);     // Activation alarme temperature
  alarme_on_v1 = read_eprom(adr_eprom_alarme_v1);         // Activation alarme V1
  alarme_on_v2 = read_eprom(adr_eprom_alarme_v2);         // Activation alarme V2
  langue = read_eprom (adr_eprom_langue);                 // Langue menu parametrage
}

// Lecture d'un mot de 16 bits en EEPROM
uint16_t GMessage::read_eprom(int address){
  return  (uint16_t) EEPROM.read(address) * 256 + EEPROM.read(address+1) ;
}

// Ecriture d'un mot de 16 bits en EEPROM
void GMessage::write_eprom(int address,uint16_t val){
  EEPROM.write(address, val  / 256);
  EEPROM.write(address+1,val % 256 );
}

// Initialisation message GAM (General Air Module)
void GMessage::init_gam_msg(){
  //met tous à Zero, puis on modifie les constantes
  memset(hott_gam_msg, 0, sizeof(struct HOTT_GAM_MSG));   
  hott_gam_msg->start_byte = 0x7c;
  hott_gam_msg->gam_sensor_id = HOTT_TELEMETRY_GAM_SENSOR_ID;
  hott_gam_msg->sensor_id = 0xd0;
  hott_gam_msg->stop_byte = 0x7d;
}

// Emission de la trame
void GMessage::send(int lenght){ 
  uint8_t sum = 0;
  delay(5);
  for(int i = 0; i < lenght-1; i++){
    sum = sum + _hott_serial_buffer[i];
    Serial.write (_hott_serial_buffer[i]);
    delayMicroseconds(HOTTV4_TX_DELAY);

    Serial.read(); // A cause du rebouclage TX <--> RX Lecture de l'octet émis 
  }  
  //Emision du checksum
  Serial.write (sum);
  delayMicroseconds(HOTTV4_TX_DELAY);
  Serial.read(); // A cause du rebouclage TX <--> RX Lecture de l'octet émis 
}

int GMessage::main(){ 
  // 
  static byte page_settings = 1;//numéro de la page de settings à afficher 
    
  if (Serial.available() >= 2) {
    uint8_t octet1 = Serial.read();
    switch (octet1) {
    case HOTT_BINARY_MODE_REQUEST_ID:
      { 
        uint8_t  octet2 = Serial.read();        
        // Demande RX Module =	$80 $XX
        switch (octet2) {
        case HOTT_TELEMETRY_GAM_SENSOR_ID: //0x8D
        {
            // init structure
            init_gam_msg();        
            
            // ******************************************************
            // Trm/min hélice
            setRPM (abs(trmn_helice_hott/10)); // ecriture RPM

            // Tension LIPO ou LIFE Accu 1 et 2
            setVoltage1 (analogique.Tension_LI1 ());
            setVoltage2 (analogique.Tension_LI2 ());

            // Temperatures moteur capteurs CTN
            setTemp(Temperature_capteur_1,1);
            setTemp(Temperature_capteur_2,2);
        
            // Gestion Alarme : envoie du code son ou message vocal          
            alarme (bip_alarme); 
            bip_alarme = 0; //   Envoye : remise a zero
              
            // altitude 0 et montée 0
            setAltitudeInMeters (0);
            setClimbrate (0);
            setClimbrate_M3 (0);              
                        
            send(sizeof(struct HOTT_GAM_MSG));
            break;
          } //end case GAM*/
        } //end case octet 2
        break;
      }

    case HOTT_TEXT_MODE_REQUEST_ID:
      {      
        uint8_t  octet3 = Serial.read();
        byte id_sensor = (octet3 >> 4);
        byte id_key = octet3 & 0x0f;
        static byte ligne_select = 2 ; // Ligne 2 selectionnée par défaut
        static int8_t ligne_edit = -1 ;
        hott_txt_msg->start_byte = 0x7b;
        hott_txt_msg->esc = 0;
        hott_txt_msg->warning_beeps = 0;
        
        memset((char *)&hott_txt_msg->text, 0x20, HOTT_TEXTMODE_MSG_TEXT_LEN);
        hott_txt_msg->stop_byte = 0x7d;
        
          if (id_sensor == (HOTT_TELEMETRY_GAM_SENSOR_ID & 0x0f)) 
          {
            
            switch (page_settings) { // Pages de parametres GlowHott
              
              case 1:   //PAGE 1 
              {          
                    if (ligne_edit == -1)
                    {
                      switch (id_key) {
                        case HOTT_KEY_UP : 
                          ligne_select = min(6,ligne_select + 1); // Ligne 6 maxi                 
                          break;                
                          
                        case HOTT_KEY_DOWN :
                          ligne_select = max(2,ligne_select - 1); //Ligne 2 mini
                          break; 
                          
                        case HOTT_KEY_SET :                      // Sélection de la ligne courante
                          ligne_edit = ligne_select ;
                          break;
                          
                        case HOTT_KEY_LEFT :        // Sortie
                          hott_txt_msg->esc = 0x01;
                          ligne_edit = -1 ;
                          ligne_select = 1;
                          break;  
                                           
                        case HOTT_KEY_RIGHT :      // passage en page 2              
                          page_settings = 2; 
                          ligne_edit = -1 ;     
                          ligne_select = 2;                     
                          break;    
                        
                        default : break;
                      }
                    }   
                      
                    //*************************************************
                    //LIGNE 3 SELECTIONNEE = Alarme batterie 1 ON / OFF
                    else if (ligne_select == 2)
                    {
                      switch (id_key) {
                        case HOTT_KEY_UP :
                          if (alarme_on_v1 == 0)
                             alarme_on_v1 = 1;                  
                          else
                             alarme_on_v1 = 0;   
                          break;
                          
                        case HOTT_KEY_DOWN :
                          if (alarme_on_v1 == 0)
                             alarme_on_v1 = 1;                  
                          else
                             alarme_on_v1 = 0;   
                          break;
                          
                        case HOTT_KEY_SET :  
                          ligne_edit = -1 ;
                          write_eprom(adr_eprom_alarme_v1,alarme_on_v1); // Ecriture EEPROM
                          break;
                          
                        case HOTT_KEY_LEFT : 
                          ligne_edit = -1;    // sortie de selection 
                          break;                            
                          
                        default : break;
                      }
                    }
                    
                    //*************************************************
                    //LIGNE 4 SELECTIONNEE = Alarme batterie 2 ON / OFF
                    else if (ligne_select == 3)
                    {
                      switch (id_key) {
                        case HOTT_KEY_UP :
                          if (alarme_on_v2 == 0)
                             alarme_on_v2 = 1;                  
                          else
                             alarme_on_v2 = 0;   
                          break;
                          
                        case HOTT_KEY_DOWN :
                          if (alarme_on_v2 == 0)
                             alarme_on_v2 = 1;                  
                          else
                             alarme_on_v2 = 0;   
                          break;
                          
                        case HOTT_KEY_SET :  
                          ligne_edit = -1 ;
                          write_eprom(adr_eprom_alarme_v2,alarme_on_v2); // Ecriture EEPROM
                          break;
                          
                        case HOTT_KEY_LEFT : 
                          ligne_edit = -1;    // sortie de selection 
                          break;                            
                          
                        default : break;
                      }
                    }
                      
                    //*************************************************
                    //LIGNE 5 SELECTIONNEE = Seuil d'alarme accu 1 en volt x 100
                    else if (ligne_select == 4)
                    {
                      switch (id_key) {
                        case HOTT_KEY_UP :
                          tension1_mini = tension1_mini + 10;     // volt x 100
                          if (tension1_mini > 840) // 8.40V
                            tension1_mini = 840;                     
                          break;
                          
                        case HOTT_KEY_DOWN :
                          tension1_mini = tension1_mini - 10;      // volt x 100
                          if (tension1_mini < 400)  // 4.00V
                              tension1_mini = 400;    
                          break;
                          
                        case HOTT_KEY_SET :  
                          ligne_edit = -1 ;
                          write_eprom(adr_eprom_v1_mini,tension1_mini);
                          break;
                          
                        case HOTT_KEY_LEFT : 
                          ligne_edit = -1;
                        break;                            
                          
                        default : break;
                      }
                    } 

                    //*************************************************
                    //LIGNE 6 SELECTIONNEE = Seuil d'alarme accu 1 en volt x 100
                    else if (ligne_select == 5)
                    {
                      switch (id_key) {
                        case HOTT_KEY_UP :
                          tension2_mini = tension2_mini + 10;     // volt x 100
                          if (tension2_mini > 840) // 8.40V
                            tension2_mini = 840;                     
                          break;
                          
                        case HOTT_KEY_DOWN :
                          tension2_mini = tension2_mini - 10;      // volt x 100
                          if (tension2_mini < 400)  // 4.00V
                              tension2_mini = 400;    
                          break;
                          
                        case HOTT_KEY_SET :  
                          ligne_edit = -1 ;
                          write_eprom(adr_eprom_v2_mini,tension2_mini);
                          break;
                          
                        case HOTT_KEY_LEFT : 
                          ligne_edit = -1;
                        break;                            
                          
                        default : break;
                      }
                    }                     

                   //*************************************************
                    //LIGNE 7 SELECTIONNEE = Langue
                    else if (ligne_select == 6)
                    {
                      switch (id_key) {
                        case HOTT_KEY_UP :
                          if (langue == FRANCAIS)
                             langue = ANGLAIS;                  
                          else
                             langue = FRANCAIS;   
                          break;
                          
                        case HOTT_KEY_DOWN :
                          if (langue == FRANCAIS)
                             langue = ANGLAIS;                  
                          else
                             langue = FRANCAIS;   
                          break;
                          
                        case HOTT_KEY_SET :  
                          ligne_edit = -1 ;
                          write_eprom(adr_eprom_langue,langue); // Ecriture EEPROM Langue
                          break;
                          
                        case HOTT_KEY_LEFT : 
                          ligne_edit = -1;    // sortie de selection 
                          break;                            
                          
                        default : break;
                      }
                    }               
                    
                    //******************************************************************************************
                    // Affichage de la page 1
                    //ligne 0:
                    snprintf((char *)&hott_txt_msg->text[0],21," * SparkHott V%s *",VERSION);
					
     	            if (langue == FRANCAIS) {
                      //line 1:
                      snprintf((char *)&hott_txt_msg->text[1],21," Gestion batterie   ");
                      //line 2:
                      if (alarme_on_v1 == 1)
                        snprintf((char *)&hott_txt_msg->text[2],21," Alarme batt. 1  ON ");
                      else 
                        snprintf((char *)&hott_txt_msg->text[2],21," Alarme batt. 1  OFF");
                      //line 3:
                      if (alarme_on_v2 == 1)
                        snprintf((char *)&hott_txt_msg->text[3],21," Alarme batt. 2  ON ");
                      else 
                        snprintf((char *)&hott_txt_msg->text[3],21," Alarme batt. 2  OFF");
                      //line 4:
                      snprintf((char *)&hott_txt_msg->text[4],21," Batt 1 mini   %i.%iV",int(tension1_mini/100),int(tension1_mini%100)); 
                      //line 5:
                      snprintf((char *)&hott_txt_msg->text[5],21," Batt 2 mini   %i.%iV",int(tension2_mini/100),int(tension2_mini%100));
                      //line 6:
                      snprintf((char *)&hott_txt_msg->text[6],21," Langue     Francais");
	            } 
	            else {     //if (langue == ANGLAIS) {
                     //line 1:
                      snprintf((char *)&hott_txt_msg->text[1],21," Battery monitoring ");
                      //line 2:
                      if (alarme_on_v1 == 1)
                        snprintf((char *)&hott_txt_msg->text[2],21," Battery 1 alarm ON ");
                      else 
                        snprintf((char *)&hott_txt_msg->text[2],21," Battery 1 alarm OFF");
                      //line 3:
                      if (alarme_on_v2 == 1)
                        snprintf((char *)&hott_txt_msg->text[3],21," Battery 2 alarm ON ");
                      else 
                        snprintf((char *)&hott_txt_msg->text[3],21," Battery 2 alarm OFF");                      
                      //line 4:
                      snprintf((char *)&hott_txt_msg->text[4],21," Mini batt 1  %i.%iV",int(tension1_mini/100),int(tension1_mini%100)); 
                      //line 5:
                      snprintf((char *)&hott_txt_msg->text[5],21," Mini batt 2  %i.%iV",int(tension2_mini/100),int(tension2_mini%100)); 									
                      //line 6:
                      snprintf((char *)&hott_txt_msg->text[6],21," Language    English");
					          }
                    //ligne 7:
                    snprintf((char *)&hott_txt_msg->text[7],21," thyzoon.fr     2018"); 
                    
                    hott_txt_msg->text[ligne_select][0] = '>';
                    _hott_invert_ligne(ligne_edit);
                    break;                    
              }//END PAGE 1
                  
              //-------------------------------------------------------------------------------------------------    
              case 2:             //PAGE 2 
              {          
                    if (ligne_edit == -1)
                    {
                      switch (id_key) {
                        case HOTT_KEY_UP : 
                          ligne_select = min(7,ligne_select + 1); // // Ligne 7 maxi                 
                          break;                
                          
                        case HOTT_KEY_DOWN :
                          ligne_select = max(2,ligne_select - 1); // // Ligne 2 mini
                          break; 
                          
                        case HOTT_KEY_SET :   // Sélection de la ligne courante
                          ligne_edit = ligne_select ;
                          break;
                          
                        case HOTT_KEY_LEFT :    // passage en page 1  
                          page_settings = 1;
                          ligne_edit = -1;
                          ligne_select = 2;                           
                          break;
                          
                         case HOTT_KEY_RIGHT :  // derniere page                 
                          break;  
                                                   
                        default : break;
                      }
                    }   

                   //*************************************************
                    //LIGNE 3 SELECTIONNEE = Alarme temperature ON / OFF
                    else if (ligne_select == 2)
                    {
                      switch (id_key) {
                        case HOTT_KEY_UP :
                          if (alarme_on_temperature == 0)
                             alarme_on_temperature = 1;                  
                          else
                             alarme_on_temperature = 0;   
                          break;
                          
                        case HOTT_KEY_DOWN :
                          if (alarme_on_temperature == 0)
                             alarme_on_temperature = 1;                  
                          else
                             alarme_on_temperature = 0;   
                          break;
                          
                        case HOTT_KEY_SET :  
                          ligne_edit = -1 ;
                          write_eprom(adr_eprom_alarme_temperature,alarme_on_temperature); // Ecriture EEPROM
                          break;
                          
                        case HOTT_KEY_LEFT : 
                          ligne_edit = -1;    // sortie de selection 
                          break;                            
                          
                        default : break;
                      }
                    }

                    //*************************************************
                    //LIGNE 4 SELECTIONNEE = Alarme chronometre temps de vol ON / OFF
                    else if (ligne_select == 3)
                    {
                      switch (id_key) {
                        case HOTT_KEY_UP :
                          if (alarme_on_chrono == 0)
                             alarme_on_chrono = 1;                  
                          else
                             alarme_on_chrono = 0;   
                          break;
                          
                        case HOTT_KEY_DOWN :
                          if (alarme_on_chrono == 0)
                             alarme_on_chrono = 1;                  
                          else
                             alarme_on_chrono = 0;   
                          break;
                          
                        case HOTT_KEY_SET :  
                          ligne_edit = -1 ;
                          write_eprom(adr_eprom_alarme_chrono,alarme_on_chrono); // Ecriture EEPROM
                          break;
                          
                        case HOTT_KEY_LEFT : 
                          ligne_edit = -1;    // sortie de selection 
                          break;                            
                          
                        default : break;
                      }
                    }                   
                        
                    //*************************************************
                    //LIGNE 5 SELECTIONNEE = Temperature moteur d'alarme (°C)
                    else if (ligne_select == 4)
                    {
                      switch (id_key) {
                        case HOTT_KEY_UP :
                          temperature_maxi = temperature_maxi + 5;     // °C
                          if (temperature_maxi > 200)
                            temperature_maxi = 200;                     
                          break;
                          
                        case HOTT_KEY_DOWN :
                          temperature_maxi = temperature_maxi - 5;      // °C
                          if (temperature_maxi < 30)
                              temperature_maxi = 30;    
                          break;
                          
                        case HOTT_KEY_SET :  
                          ligne_edit = -1 ;
                          write_eprom(adr_eprom_temperature_max,temperature_maxi);
                          break;
                          
                        case HOTT_KEY_LEFT : 
                          ligne_edit = -1;
                        break;                            
                          
                        default : break;
                      }
                    } 
                    
                    //*************************************************
                    //LIGNE 6 SELECTIONNEE = Regime max. moteur
                    else if (ligne_select == 5)
                    {
                      switch (id_key) {
                        case HOTT_KEY_UP :
                          regime_moteur_maxi = regime_moteur_maxi + 25; 
                          if (regime_moteur_maxi > 2500)  // 25000 tr/min
                            regime_moteur_maxi = 2500;                     
                          break;
                          
                        case HOTT_KEY_DOWN :
                          regime_moteur_maxi = regime_moteur_maxi - 25; 
                          if (regime_moteur_maxi < 700)  // 8000 tr/min
                              regime_moteur_maxi = 700;    
                          break;
                          
                        case HOTT_KEY_SET :  
                          ligne_edit = -1 ;
                          write_eprom(adr_eprom_regime_maxi,regime_moteur_maxi); 
                          break;
                          
                        case HOTT_KEY_LEFT : 
                          ligne_edit = -1;
                        break;                            
                          
                        default : break;
                      }
                    }
                    //*************************************************
                    //LIGNE 7 SELECTIONNEE = Chronometre temps moteur tournant
                    else if (ligne_select == 6)
                    {
                      switch (id_key) {                      
                        case HOTT_KEY_UP :
                          chrono_moteur = chrono_moteur + 60;    // secondes
                          if (chrono_moteur > 1200)   // 20 minutes
                            chrono_moteur = 1200;                     
                          break;
                          
                        case HOTT_KEY_DOWN :
                          chrono_moteur = chrono_moteur - 60; // secondes
                          if (chrono_moteur <= 120)   // 2 minutes
                            chrono_moteur = 120;    
                          break;
                          
                        case HOTT_KEY_SET :  
                          ligne_edit = -1 ;
                          write_eprom(adr_eprom_chrono_moteur,chrono_moteur); // Ecriture EEPROM
                          break;
                          
                        case HOTT_KEY_LEFT : 
                          ligne_edit = -1;          // sortie de selection 
                        break;                            
                          
                        default : break;
                      }
                    }

                    //*************************************************
                    //LIGNE 8 SELECTIONNEE = Delai de repetition de l'alarme temps moteur
                    else if (ligne_select == 7)
                    {
                      switch (id_key) {
                        case HOTT_KEY_UP :
                          alarme_repet = alarme_repet + 15;   // secondes
                          if (alarme_repet > 60)   // secondes
                            alarme_repet = 60;                     
                          break;
                          
                        case HOTT_KEY_DOWN :
                          alarme_repet = alarme_repet - 15;  // secondes
                          if (alarme_repet <= 15)  
                              alarme_repet = 15;    
                          break;
                          
                        case HOTT_KEY_SET :  
                          ligne_edit = -1 ;
                          write_eprom(adr_eprom_alarme_repet,alarme_repet);

                          break;
                          
                        case HOTT_KEY_LEFT : 
                          ligne_edit = -1;
                        break;                            
                          
                        default : break;
                      }
                    }                   
                    
                    //******************************************************************************************
                    // Affichage de la page 2
                    //ligne 0:
                     snprintf((char *)&hott_txt_msg->text[0],21," * SparkHott V%s *",VERSION);
					          if (langue == FRANCAIS) {
                       //ligne 1:
                      snprintf((char *)&hott_txt_msg->text[1],21," Gestion moteur     ");
                      //ligne 2:
                      if (alarme_on_temperature == 1)
                        snprintf((char *)&hott_txt_msg->text[2],21," Alarme temp.    ON ");
                      else 
                        snprintf((char *)&hott_txt_msg->text[2],21," Alarme temp.    OFF");
                      //ligne 3:
                      if (alarme_on_chrono == 1)
                        snprintf((char *)&hott_txt_msg->text[3],21," Chrono moteur   ON ");
                      else 
                        snprintf((char *)&hott_txt_msg->text[3],21," Chrono moteur   OFF");
                      //ligne 4:
                      snprintf((char *)&hott_txt_msg->text[4],21," Temperature %3i Deg",temperature_maxi);
                      //ligne 5:
                      snprintf((char *)&hott_txt_msg->text[5],21," Regime Maxi   %i",regime_moteur_maxi*10); 
                      //ligne 6:
                      snprintf((char *)&hott_txt_msg->text[6],21," Chrono moteur %2imin",chrono_moteur/60);
                      //ligne 7:
                      snprintf((char *)&hott_txt_msg->text[7],21," Repetition chro %2is",alarme_repet);
                     }
		      else {     //if (langue == ANGLAIS) {					
                      //ligne 1:
                      snprintf((char *)&hott_txt_msg->text[1],21," Engine monitoring  ");
                      //ligne 2:
                      if (alarme_on_temperature == 1)
                        snprintf((char *)&hott_txt_msg->text[2],21," Temp. alarm     ON ");
                      else 
                        snprintf((char *)&hott_txt_msg->text[2],21," Temp. alarm     OFF");
                      //ligne 3:
                      if (alarme_on_chrono == 1)
                        snprintf((char *)&hott_txt_msg->text[3],21," Flight timer    ON ");
                      else 
                        snprintf((char *)&hott_txt_msg->text[3],21," Flight timer    OFF");
                      //ligne 4:
                      snprintf((char *)&hott_txt_msg->text[4],21," Temperature %3i Deg",temperature_maxi);
                      //ligne 5:
                      snprintf((char *)&hott_txt_msg->text[5],21," Max RPMs      %i",regime_moteur_maxi*10);                    
                      //ligne 6:
                      snprintf((char *)&hott_txt_msg->text[6],21," Flight timer  %2imin",chrono_moteur/60);
                      //line 7:
                      snprintf((char *)&hott_txt_msg->text[7],21," Repeat Fl Timer %2is",alarme_repet); 
					            }
                      hott_txt_msg->text[ligne_select][0] = '>';
                      _hott_invert_ligne(ligne_edit);
                    break;                    
                  }//END PAGE 2   
                  
                  default: //PAGE 
                  {
                    break;
                  }            
                 
            }//END SETTINGS 
            // Emission en mode texte
			_hott_send_text_msg();  // Trame GAM
          } // END IF :  id_sensor = HOTT_TELEMETRY_GAM_SENSOR_ID 
          
          //********************************************************************************************************************
          /*
          else if(id_sensor == (HOTT_TELEMETRY_GEA_SENSOR_ID & 0x0f)) {
            snprintf((char *)&hott_txt_msg->text[0],21,"Module EAM");
            snprintf((char *)&hott_txt_msg->text[1],21,"----------");
            snprintf((char *)&hott_txt_msg->text[2],21,"Selectionner :");
            snprintf((char *)&hott_txt_msg->text[3],21," GENERAL");
          }
          else if(id_sensor == (HOTT_TELEMETRY_VARIO_SENSOR_ID & 0x0f)) {         
            snprintf((char *)&hott_txt_msg->text[0],21,"Module VARIO");
            snprintf((char *)&hott_txt_msg->text[1],21,"------------");
            snprintf((char *)&hott_txt_msg->text[2],21,"Selectionner :");
            snprintf((char *)&hott_txt_msg->text[3],21," GENERAL");
          }
          else {
            snprintf((char *)&hott_txt_msg->text[0],21,"Module inconnu");
            snprintf((char *)&hott_txt_msg->text[1],21,"--------------");
            snprintf((char *)&hott_txt_msg->text[2],21,"Selectionner :");
            snprintf((char *)&hott_txt_msg->text[3],21," GENERAL");
          }*/
        //}

        break;
      }
    }	
    return (1);
  }
  else
   return (0);
}

//////////////////////////////////////////////////
// Tension principale (resolution 0.1V)
void GMessage::setMainVoltage(float tension){
  hott_gam_msg->main_voltage = (uint16_t) (tension * 10);
}

// Batterie 1 (resolution 0.1V)
void GMessage::setVoltage1(float volt){
  hott_gam_msg->Battery1 =  (uint16_t) (volt * 10); 
}

// Batterie 2 (resolution 0.1V)
void GMessage::setVoltage2(float volt){
  hott_gam_msg->Battery2 = (uint16_t) (volt * 10); 
}

// Element Lipo n (resolution 0.02V)
void GMessage::setLipo(float volt, int lipo){

  if (lipo >= 1 and lipo <= 6)
  {
    lipo--;
    hott_gam_msg->cell[lipo] =  (uint16_t) 100 * volt / 2 ; 
    
    if (volt/2 <= hott_gam_msg->min_cell_volt || hott_gam_msg->min_cell_volt ==0)
    {
      hott_gam_msg->min_cell_volt = (uint16_t) 100 * volt/2 ;
      hott_gam_msg->min_cell_volt_num = lipo;
    }
  }
}

// Altitude relative en metres : -500 / +9999 [m]
void GMessage::setAltitudeInMeters(uint16_t alti){
  hott_gam_msg->altitude = alti + 500;
}

// Temperature : -20 a +235° C 
// 
void GMessage::setTemp(int temp, int capteur){
  if(temp < -20)
    temp = -20;
  else if(temp > 234)
    temp = 235;
  if (capteur < 1)
    capteur = 1;
  if (capteur > 2)
    capteur = 2; 
  if (capteur == 1)
    hott_gam_msg->temperature1 = temp + 20;
  else if (capteur == 2)
    hott_gam_msg->temperature2 = temp + 20;
}

// Niveau reservoir : 0%, 25%, 50%, 75%, 100%  
// 
void GMessage::setFuelPercent(uint8_t pourcent){
  if(pourcent > 100)
    pourcent = 100;
  else if(pourcent < 0)
    pourcent = 0;
  hott_gam_msg->fuel_procent = pourcent ;
}

// niveau reservoir en ml : 0 a 65535 ml
// 
void GMessage::setFuelMilliliters(uint16_t ml){
  hott_gam_msg->fuel_ml = ml ;
}

// Rotation : 0 a 655350 tr/min
// 

void GMessage::setRPM(uint16_t rpm){
  hott_gam_msg->rpm = rpm ;
} 

// Set climbrates
void GMessage::setClimbrate(uint16_t climb_L){
  hott_gam_msg->climbrate_L =  climb_L+30000;
}

void GMessage::setClimbrate_M3(int climb3s){
  hott_gam_msg->climbrate3s =  climb3s+120;
}

// Set speed
void GMessage::setSpeed(float speed){
  hott_gam_msg->climbrate3s =  (int) speed;
}


//
// Alarme sonore sur radio
//
void GMessage::alarme (uint8_t son){
  hott_gam_msg->warning_beeps = son;
}

void GMessage::_hott_send_text_msg() {
  for(byte *_hott_msg_ptr = hott_txt_msg->text[0]; _hott_msg_ptr < &hott_txt_msg->stop_byte ; _hott_msg_ptr++){
    if (*_hott_msg_ptr == 0)
      *_hott_msg_ptr = 0x20;
  }  
  //_hott_send_msg(_hott_serial_buffer, sizeof(struct HOTT_TEXTMODE_MSG));
  send(sizeof(struct HOTT_TEXTMODE_MSG));
}

char * GMessage::_hott_invert_all_chars(char *str) {
  return _hott_invert_chars(str, 0);
}

char * GMessage::_hott_invert_chars(char *str, int cnt) {
  if(str == 0) return str;
  int len = strlen(str);
  if((len < cnt)  && cnt > 0) len = cnt;
  for(int i=0; i< len; i++) {
    str[i] = (byte)(0x80 + (byte)str[i]);
  }
  return str;
}

void GMessage::_hott_invert_ligne(int ligne) {
  if (ligne>= 0 && ligne<= 7)
    for(int i=0; i< 21; i++) {
      if (hott_txt_msg->text[ligne][i] == 0)   //inversion du caratère null (fin de string)
        hott_txt_msg->text[ligne][i] = (byte)(0x80 + 0x20);
      else
        hott_txt_msg->text[ligne][i] = (byte)(0x80 + (byte)hott_txt_msg->text[ligne][i]);
    }
}



