//
//  Mesure des tensions et températures
//
//  www.thyzoon.fr
//  2015-2018
//

#include "Arduino.h"
#include "Mesure.h"
#include <math.h>

Mesure::Mesure () {
}

// Initialisation CAN et entrées
void Mesure::init(){
   analogReference(DEFAULT); // reference : alimentation 3.3V ou 5V
   
   // Configuration des entrées Analogiques.
   digitalWrite(A0, LOW); 
   pinMode(A0, INPUT);
   digitalWrite(A1, LOW); 
   pinMode(A1, INPUT);
   digitalWrite(A2, LOW); 
   pinMode(A2, INPUT);
   digitalWrite(A3, LOW); 
   pinMode(A3, INPUT);   
}

// Mesure de la tension de l'accumulateur LIPO 2S ou LIFE 2S sur A0
float Mesure::Tension_LI1 () {
  float li;
  
  li = lecture_can (A0) * VREF / RESOLUTION;
  li = (li / R2) * (R1 + R2);
  
  return li;  
}

// Mesure de la tension de l'accumulateur LIPO 2S ou LIFE 2S sur A1
float Mesure::Tension_LI2 () {
  float li;
  
  li = lecture_can (A1) * VREF / RESOLUTION;
  li = (li / R4) * (R3 + R4);
  
  return li;  
}

//------------------------------------------------------------
// Mesure de la temperature (CTN) sur A2 ou A3
//
// Temps d'execution sur Arduino Pro Mini 8 MHz : -
// Temps d'execution sur Arduino Pro Mini 16 MHz : -
//
int Mesure::Temperature (int canal) {
  float temperature;
  float tension;
  float courant;
  float rctn;
  float logr;
  int temp;
  
  if (canal==1)
   tension = lecture_can (A2) * VREF / RESOLUTION;      // tension lue par le CAN voie A2 sur CTN
  else 
   tension = lecture_can (A3) * VREF / RESOLUTION;      // tension lue par le CAN voie A3 sur CTN	 
 
  courant = (VREF - tension) / RL;                      // courant dans CTN
  rctn = tension / courant;                             // Valeur resistance CTN
  
  logr = log (rctn/R25);
  // Calcul temperature en °C
  temperature = 1/ (CA + CB * logr + CC * logr * logr + CD * logr * logr * logr) + ZERO_KELVIN;
  
  temp = round (temperature);
  
  return temp; 
}  

// Mesure tension sur convertisseur A/N 
uint16_t Mesure::lecture_can (uint8_t pin){
  uint16_t val = analogRead(pin); 
  return val;
}
