//
//  Mesure des tensions et températures
//
//  www.thyzoon.fr
//  2015-2018
//

#include "Arduino.h"

// parametres CAN
#define VREF 3.3         // reference de tension du CAN
#define RESOLUTION 1024  // resolution du CAN

// resistance mesure tension LIFE ou LIPO
#define R1 3480 // resistances du pont de mesure
#define R2 2150 // de la tension LIFE ou LIPO 1
#define R3 3480 // resistances du pont de mesure
#define R4 2150 // de la tension LIFE ou LIPO 2

// Paramètres mesures de temperature (Caracteristiques CTN)
// CTN : Vishay NTCLE300E3502SB 
// Coefficients Steinhart & Hart 
// Remarque : 
// 		Sur Arduino 328p, les nombres a virgule sont limites en precision au 'float', le 'double' est identique au 'float'
// 		En 'float', il y a seulement 6 a 7 chiffres significatifs , la precision des coef ci-dessous n'est dons pas prise en compte. 
#define CA	0.00335401643468053	
#define CB	0.00025698501802
#define CC	0.0000026201306709
#define CD	0.000000063830907998

#define R25 5000            // Rctn à 298.15 K (25°C)
#define RL  1500            // resistance Rx du pont
#define ZERO_KELVIN -273.15 // -273.15 °C = 0 Kelvin


class Mesure{
  public:
  void init(); 
  float Tension_LI1 ();
  float Tension_LI2 ();
  int Temperature (int canal);
  Mesure ();
  
  private:
  uint16_t lecture_can (uint8_t pin);
};
