//
//  Gestion des interruptions 
//    INT1 : signal impulsion pales helices
//
//  www.thyzoon.fr
//  2015-2018
//

#include "Arduino.h"

// Entrée PIN 3
#define Ctr_pin 3 

//**************************************
// Mesure du temps entre pales
// La resolution est d'environ : 
//  4µs avec un ATMEGA328p à 16MHz
//  8µs avec un ATMEGA328p à 8MHz

void Capture_Ctr() {

  extern unsigned long temps_helice;  // temps pour entre 2 passages de pales en µs
  extern boolean flag_temps_helice;   // temps valide 
  static unsigned long t0 = 0;        // temps mémorisé au front montant 
  static unsigned long tp = 0;        // temps mémorisé au front montant précédent
  unsigned long tps;

  t0 = micros();
  tps = t0 - tp;
  temps_helice = tps;
  flag_temps_helice = true;  
  tp = t0;          // temps précédent
}

//***************************************
// Gestion de l'entrée sous interrruption
void Init_ctr() {
  // Interruption 1
  // Broche 3
  pinMode(Ctr_pin, INPUT);
  // prise en compte INT sur front descendant
  attachInterrupt(1, Capture_Ctr , FALLING); 
}  
